<?php
/**
 * PublicExportListRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Exports
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CRM Exports
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Exports\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Exports\ObjectSerializer;

/**
 * PublicExportListRequest Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Exports
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicExportListRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicExportListRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'export_type' => 'string',
        'format' => 'string',
        'export_name' => 'string',
        'object_properties' => 'string[]',
        'associated_object_type' => 'string',
        'object_type' => 'string',
        'language' => 'string',
        'export_internal_values_options' => 'string[]',
        'override_associated_objects_per_definition_per_row_limit' => 'bool',
        'public_crm_search_request' => '\HubSpot\Client\Crm\Exports\Model\PublicCrmSearchRequest',
        'list_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'export_type' => null,
        'format' => null,
        'export_name' => null,
        'object_properties' => null,
        'associated_object_type' => null,
        'object_type' => null,
        'language' => null,
        'export_internal_values_options' => null,
        'override_associated_objects_per_definition_per_row_limit' => null,
        'public_crm_search_request' => null,
        'list_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'export_type' => false,
        'format' => false,
        'export_name' => false,
        'object_properties' => false,
        'associated_object_type' => false,
        'object_type' => false,
        'language' => false,
        'export_internal_values_options' => false,
        'override_associated_objects_per_definition_per_row_limit' => false,
        'public_crm_search_request' => false,
        'list_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'export_type' => 'exportType',
        'format' => 'format',
        'export_name' => 'exportName',
        'object_properties' => 'objectProperties',
        'associated_object_type' => 'associatedObjectType',
        'object_type' => 'objectType',
        'language' => 'language',
        'export_internal_values_options' => 'exportInternalValuesOptions',
        'override_associated_objects_per_definition_per_row_limit' => 'overrideAssociatedObjectsPerDefinitionPerRowLimit',
        'public_crm_search_request' => 'publicCrmSearchRequest',
        'list_id' => 'listId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'export_type' => 'setExportType',
        'format' => 'setFormat',
        'export_name' => 'setExportName',
        'object_properties' => 'setObjectProperties',
        'associated_object_type' => 'setAssociatedObjectType',
        'object_type' => 'setObjectType',
        'language' => 'setLanguage',
        'export_internal_values_options' => 'setExportInternalValuesOptions',
        'override_associated_objects_per_definition_per_row_limit' => 'setOverrideAssociatedObjectsPerDefinitionPerRowLimit',
        'public_crm_search_request' => 'setPublicCrmSearchRequest',
        'list_id' => 'setListId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'export_type' => 'getExportType',
        'format' => 'getFormat',
        'export_name' => 'getExportName',
        'object_properties' => 'getObjectProperties',
        'associated_object_type' => 'getAssociatedObjectType',
        'object_type' => 'getObjectType',
        'language' => 'getLanguage',
        'export_internal_values_options' => 'getExportInternalValuesOptions',
        'override_associated_objects_per_definition_per_row_limit' => 'getOverrideAssociatedObjectsPerDefinitionPerRowLimit',
        'public_crm_search_request' => 'getPublicCrmSearchRequest',
        'list_id' => 'getListId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const EXPORT_TYPE__LIST = 'LIST';
    public const FORMAT_XLS = 'XLS';
    public const FORMAT_XLSX = 'XLSX';
    public const FORMAT_CSV = 'CSV';
    public const LANGUAGE_EN = 'EN';
    public const LANGUAGE_DE = 'DE';
    public const LANGUAGE_ES = 'ES';
    public const LANGUAGE_FR = 'FR';
    public const LANGUAGE_JA = 'JA';
    public const LANGUAGE_NL = 'NL';
    public const LANGUAGE_PT_BR = 'PT_BR';
    public const LANGUAGE_IT = 'IT';
    public const LANGUAGE_PL = 'PL';
    public const LANGUAGE_SV = 'SV';
    public const LANGUAGE_FI = 'FI';
    public const LANGUAGE_ZH_TW = 'ZH_TW';
    public const LANGUAGE_DA_DK = 'DA_DK';
    public const LANGUAGE_NO = 'NO';
    public const EXPORT_INTERNAL_VALUES_OPTIONS_NAMES = 'NAMES';
    public const EXPORT_INTERNAL_VALUES_OPTIONS_VALUES = 'VALUES';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getExportTypeAllowableValues()
    {
        return [
            self::EXPORT_TYPE__LIST,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFormatAllowableValues()
    {
        return [
            self::FORMAT_XLS,
            self::FORMAT_XLSX,
            self::FORMAT_CSV,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLanguageAllowableValues()
    {
        return [
            self::LANGUAGE_EN,
            self::LANGUAGE_DE,
            self::LANGUAGE_ES,
            self::LANGUAGE_FR,
            self::LANGUAGE_JA,
            self::LANGUAGE_NL,
            self::LANGUAGE_PT_BR,
            self::LANGUAGE_IT,
            self::LANGUAGE_PL,
            self::LANGUAGE_SV,
            self::LANGUAGE_FI,
            self::LANGUAGE_ZH_TW,
            self::LANGUAGE_DA_DK,
            self::LANGUAGE_NO,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getExportInternalValuesOptionsAllowableValues()
    {
        return [
            self::EXPORT_INTERNAL_VALUES_OPTIONS_NAMES,
            self::EXPORT_INTERNAL_VALUES_OPTIONS_VALUES,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('export_type', $data ?? [], 'LIST');
        $this->setIfExists('format', $data ?? [], null);
        $this->setIfExists('export_name', $data ?? [], null);
        $this->setIfExists('object_properties', $data ?? [], null);
        $this->setIfExists('associated_object_type', $data ?? [], null);
        $this->setIfExists('object_type', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('export_internal_values_options', $data ?? [], null);
        $this->setIfExists('override_associated_objects_per_definition_per_row_limit', $data ?? [], null);
        $this->setIfExists('public_crm_search_request', $data ?? [], null);
        $this->setIfExists('list_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['export_type'] === null) {
            $invalidProperties[] = "'export_type' can't be null";
        }
        $allowedValues = $this->getExportTypeAllowableValues();
        if (!is_null($this->container['export_type']) && !in_array($this->container['export_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'export_type', must be one of '%s'",
                $this->container['export_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['format'] === null) {
            $invalidProperties[] = "'format' can't be null";
        }
        $allowedValues = $this->getFormatAllowableValues();
        if (!is_null($this->container['format']) && !in_array($this->container['format'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'format', must be one of '%s'",
                $this->container['format'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['export_name'] === null) {
            $invalidProperties[] = "'export_name' can't be null";
        }
        if ($this->container['object_properties'] === null) {
            $invalidProperties[] = "'object_properties' can't be null";
        }
        if ($this->container['object_type'] === null) {
            $invalidProperties[] = "'object_type' can't be null";
        }
        if ($this->container['language'] === null) {
            $invalidProperties[] = "'language' can't be null";
        }
        $allowedValues = $this->getLanguageAllowableValues();
        if (!is_null($this->container['language']) && !in_array($this->container['language'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'language', must be one of '%s'",
                $this->container['language'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['export_internal_values_options'] === null) {
            $invalidProperties[] = "'export_internal_values_options' can't be null";
        }
        if ($this->container['override_associated_objects_per_definition_per_row_limit'] === null) {
            $invalidProperties[] = "'override_associated_objects_per_definition_per_row_limit' can't be null";
        }
        if ($this->container['list_id'] === null) {
            $invalidProperties[] = "'list_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets export_type
     *
     * @return string
     */
    public function getExportType()
    {
        return $this->container['export_type'];
    }

    /**
     * Sets export_type
     *
     * @param string $export_type export_type
     *
     * @return self
     */
    public function setExportType($export_type)
    {
        if (is_null($export_type)) {
            throw new \InvalidArgumentException('non-nullable export_type cannot be null');
        }
        $allowedValues = $this->getExportTypeAllowableValues();
        if (!in_array($export_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'export_type', must be one of '%s'",
                    $export_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['export_type'] = $export_type;

        return $this;
    }

    /**
     * Gets format
     *
     * @return string
     */
    public function getFormat()
    {
        return $this->container['format'];
    }

    /**
     * Sets format
     *
     * @param string $format format
     *
     * @return self
     */
    public function setFormat($format)
    {
        if (is_null($format)) {
            throw new \InvalidArgumentException('non-nullable format cannot be null');
        }
        $allowedValues = $this->getFormatAllowableValues();
        if (!in_array($format, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'format', must be one of '%s'",
                    $format,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['format'] = $format;

        return $this;
    }

    /**
     * Gets export_name
     *
     * @return string
     */
    public function getExportName()
    {
        return $this->container['export_name'];
    }

    /**
     * Sets export_name
     *
     * @param string $export_name export_name
     *
     * @return self
     */
    public function setExportName($export_name)
    {
        if (is_null($export_name)) {
            throw new \InvalidArgumentException('non-nullable export_name cannot be null');
        }
        $this->container['export_name'] = $export_name;

        return $this;
    }

    /**
     * Gets object_properties
     *
     * @return string[]
     */
    public function getObjectProperties()
    {
        return $this->container['object_properties'];
    }

    /**
     * Sets object_properties
     *
     * @param string[] $object_properties object_properties
     *
     * @return self
     */
    public function setObjectProperties($object_properties)
    {
        if (is_null($object_properties)) {
            throw new \InvalidArgumentException('non-nullable object_properties cannot be null');
        }
        $this->container['object_properties'] = $object_properties;

        return $this;
    }

    /**
     * Gets associated_object_type
     *
     * @return string|null
     */
    public function getAssociatedObjectType()
    {
        return $this->container['associated_object_type'];
    }

    /**
     * Sets associated_object_type
     *
     * @param string|null $associated_object_type associated_object_type
     *
     * @return self
     */
    public function setAssociatedObjectType($associated_object_type)
    {
        if (is_null($associated_object_type)) {
            throw new \InvalidArgumentException('non-nullable associated_object_type cannot be null');
        }
        $this->container['associated_object_type'] = $associated_object_type;

        return $this;
    }

    /**
     * Gets object_type
     *
     * @return string
     */
    public function getObjectType()
    {
        return $this->container['object_type'];
    }

    /**
     * Sets object_type
     *
     * @param string $object_type object_type
     *
     * @return self
     */
    public function setObjectType($object_type)
    {
        if (is_null($object_type)) {
            throw new \InvalidArgumentException('non-nullable object_type cannot be null');
        }
        $this->container['object_type'] = $object_type;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string $language language
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $allowedValues = $this->getLanguageAllowableValues();
        if (!in_array($language, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'language', must be one of '%s'",
                    $language,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets export_internal_values_options
     *
     * @return string[]
     */
    public function getExportInternalValuesOptions()
    {
        return $this->container['export_internal_values_options'];
    }

    /**
     * Sets export_internal_values_options
     *
     * @param string[] $export_internal_values_options export_internal_values_options
     *
     * @return self
     */
    public function setExportInternalValuesOptions($export_internal_values_options)
    {
        if (is_null($export_internal_values_options)) {
            throw new \InvalidArgumentException('non-nullable export_internal_values_options cannot be null');
        }
        $allowedValues = $this->getExportInternalValuesOptionsAllowableValues();
        if (array_diff($export_internal_values_options, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'export_internal_values_options', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['export_internal_values_options'] = $export_internal_values_options;

        return $this;
    }

    /**
     * Gets override_associated_objects_per_definition_per_row_limit
     *
     * @return bool
     */
    public function getOverrideAssociatedObjectsPerDefinitionPerRowLimit()
    {
        return $this->container['override_associated_objects_per_definition_per_row_limit'];
    }

    /**
     * Sets override_associated_objects_per_definition_per_row_limit
     *
     * @param bool $override_associated_objects_per_definition_per_row_limit override_associated_objects_per_definition_per_row_limit
     *
     * @return self
     */
    public function setOverrideAssociatedObjectsPerDefinitionPerRowLimit($override_associated_objects_per_definition_per_row_limit)
    {
        if (is_null($override_associated_objects_per_definition_per_row_limit)) {
            throw new \InvalidArgumentException('non-nullable override_associated_objects_per_definition_per_row_limit cannot be null');
        }
        $this->container['override_associated_objects_per_definition_per_row_limit'] = $override_associated_objects_per_definition_per_row_limit;

        return $this;
    }

    /**
     * Gets public_crm_search_request
     *
     * @return \HubSpot\Client\Crm\Exports\Model\PublicCrmSearchRequest|null
     */
    public function getPublicCrmSearchRequest()
    {
        return $this->container['public_crm_search_request'];
    }

    /**
     * Sets public_crm_search_request
     *
     * @param \HubSpot\Client\Crm\Exports\Model\PublicCrmSearchRequest|null $public_crm_search_request public_crm_search_request
     *
     * @return self
     */
    public function setPublicCrmSearchRequest($public_crm_search_request)
    {
        if (is_null($public_crm_search_request)) {
            throw new \InvalidArgumentException('non-nullable public_crm_search_request cannot be null');
        }
        $this->container['public_crm_search_request'] = $public_crm_search_request;

        return $this;
    }

    /**
     * Gets list_id
     *
     * @return string
     */
    public function getListId()
    {
        return $this->container['list_id'];
    }

    /**
     * Sets list_id
     *
     * @param string $list_id list_id
     *
     * @return self
     */
    public function setListId($list_id)
    {
        if (is_null($list_id)) {
            throw new \InvalidArgumentException('non-nullable list_id cannot be null');
        }
        $this->container['list_id'] = $list_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


