<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('frontend_footer_settings', function (Blueprint $table) {
            if (! Schema::hasColumn('frontend_footer_settings', 'no_credit_cart_required')) {
                $table->string('no_credit_cart_required', 500)->default('No credit cart required.')->nullable();
            }

            if (! Schema::hasColumn('frontend_footer_settings', 'faster_content_creation')) {
                $table->string('faster_content_creation', 500)->default('<span class="font-heading text-[1.857em]/[1em] font-bold">10x</span>Faster Content Creation')->nullable();
            }
            if (! Schema::hasColumn('frontend_footer_settings', 'over_5000_businesses')) {
                $table->string('over_5000_businesses', 500)->default('over <u>5000+</u> businesses trust us to boost their social media precense')->nullable();
            }
            if (! Schema::hasColumn('frontend_footer_settings', 'join_the_ranks')) {
                $table->longText('join_the_ranks')->nullable();
            }
        });

        if (Schema::hasColumn('frontend_footer_settings', 'join_the_ranks')) {
            $find = \App\Models\Frontend\FrontendSetting::query()->first();
            if ($find) {
                $find->join_the_ranks = 'Join the ranks of renowned
                    <svg
                        class="lqd-split-word lqd-split-unit inline align-middle"
                        width="44"
                        height="45"
                        viewBox="0 0 44 45"
                        fill="currentColor"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <path
                            d="M2.49367 26.2332C2.00532 26.3607 1.51695 26.5114 1.01697 26.6041C0.365823 26.7316 -0.0527636 26.4418 0.00537425 25.8275C0.0751397 25.1204 0.168167 24.4017 0.993725 24.0424C3.36575 22.9991 5.72614 21.9443 8.08653 20.8547C9.70277 20.1128 11.3074 19.313 12.912 18.5364C12.9818 18.5016 13.005 18.3857 13.1213 18.1538C12.819 17.9452 12.4934 17.7249 12.1794 17.5047H12.2027C12.598 17.5743 13.0166 17.5511 13.3771 17.7018C13.9701 17.9452 14.3306 17.7365 14.8189 17.1454C13.9236 16.6237 13.1213 16.1485 12.319 15.6732C12.319 15.6732 12.3422 15.6964 12.3539 15.708C11.4469 15.2675 10.54 14.7923 9.60976 14.3866C8.81909 14.0388 7.99352 13.7722 7.04006 13.4245C7.26098 13.2738 7.41214 13.181 7.62144 13.0419C7.48191 12.2305 6.65634 12.2073 6.14473 12.0335C5.22615 11.7089 4.72617 11.2568 4.43548 10.2831C4.23781 9.62241 3.79597 8.93851 2.95879 8.66032C2.203 8.41689 1.49371 7.988 0.737917 7.62866C1.17976 7.46638 1.59835 7.31568 2.01694 7.16499L1.98206 7.25772L2.02858 7.19976C1.9123 6.92156 1.80764 6.64338 1.69137 6.34199C3.54015 5.86674 5.16802 5.97106 6.78425 6.95635C8.54002 8.03437 10.4586 8.85736 12.2376 9.90061C13.7027 10.7584 15.0747 11.7669 16.4816 12.7174C16.47 12.7406 16.4584 12.7521 16.4351 12.7637C16.4584 12.7406 16.47 12.7058 16.4933 12.6826C17.47 13.0072 17.4351 12.984 17.9351 12.1262C19.8071 8.90373 21.6559 5.66968 23.621 2.50517C24.1558 1.6358 25.0395 0.96348 25.8535 0.302758C26.1674 0.0477427 26.7139 -0.010209 27.1441 0.00138263C27.493 0.00138263 27.5278 0.325953 27.3185 0.604151H27.3534C27.4581 0.685293 27.5744 0.789617 27.679 0.893941V0.9403C27.8999 1.02144 28.1441 1.10258 28.3767 1.2069C28.3999 1.21849 28.365 1.39237 28.3534 1.48511C28.3418 1.80967 28.3301 2.12265 28.3185 2.44721L27.6092 2.52834C27.6441 2.62108 27.679 2.7254 27.7255 2.81814C27.9232 2.67904 28.1208 2.55154 28.3069 2.41244C28.3301 2.09947 28.3418 1.78649 28.365 1.48511C28.5859 1.56625 28.8185 1.65898 29.0394 1.74012L29.0162 1.70535C29.2255 1.80967 29.4231 1.91399 29.6324 2.01831L29.5859 1.98354C30.2138 2.31969 30.8533 2.65586 31.6207 3.06157C31.2835 3.35136 31.0045 3.59479 30.5743 3.95413H33.9114C33.737 4.80031 34.1323 5.24079 34.7137 5.57694C34.8648 5.66968 35.016 5.79718 35.1323 5.93628C35.8067 6.77088 35.5974 7.44319 34.5393 7.90685C34.5393 7.72138 34.5625 7.53592 34.5741 7.35046C34.4346 7.44319 34.2835 7.51274 34.1672 7.61706C34.1091 7.66343 34.0974 7.76777 34.0742 7.84891C33.9811 7.90686 33.8881 7.9764 33.7951 8.03436C33.8532 8.06913 33.9114 8.11551 33.9695 8.15028C33.9928 8.04596 34.016 7.93004 34.0393 7.82572C34.2253 7.83731 34.3997 7.86049 34.5858 7.87208C34.6323 8.26619 34.6904 8.6719 34.7369 9.06601L34.7718 9.10078C33.9579 8.63712 33.8184 8.6719 33.1556 9.51808C32.83 9.66877 32.3417 9.57604 32.2254 10.2947C32.6207 9.95856 32.8882 9.73833 33.1556 9.5065C33.2835 9.93539 33.3998 10.3643 33.5393 10.8511C34.1556 10.515 34.7486 10.4918 35.3532 11.083C35.1555 12.1726 34.1323 12.5667 33.4114 13.2158C33.016 13.5636 32.644 13.9461 32.2603 14.3054C32.0859 14.3402 31.9231 14.3866 31.7487 14.4213C31.7487 14.4445 31.7603 14.4677 31.7719 14.4909C31.9231 14.4213 32.0858 14.3518 32.237 14.2938C32.9347 14.0968 33.6439 13.9113 34.3416 13.7143V13.6795C34.4114 13.8186 34.4927 13.9577 34.5741 14.0968C34.5393 14.0736 34.5044 14.062 34.4695 14.0388C34.5044 14.062 34.5393 14.0852 34.5741 14.1084C34.6672 13.8534 35.4578 13.9229 34.923 13.3781L34.9695 13.4013C34.9811 13.2854 34.9927 13.1694 35.0044 13.0535H34.9695C35.7485 13.0535 36.5276 13.0535 37.5741 13.0535C37.0973 13.5867 36.795 13.9345 36.3183 14.4793C37.5857 14.3286 38.6089 14.2011 39.6321 14.0736C39.9926 14.8966 39.4694 15.1516 39.0043 15.453C38.481 15.7776 37.981 16.1485 37.4694 16.4962C36.6555 16.4035 36.0741 16.7628 35.5974 17.3888C35.3299 17.4236 35.0625 17.4699 34.7951 17.5163L33.9811 18.1075C33.6207 18.2466 33.2486 18.3857 32.8881 18.5248C32.923 18.5943 32.9695 18.6639 33.0044 18.7334C33.3184 18.5132 33.6323 18.3045 33.9463 18.0959C34.2253 17.8988 34.4928 17.7018 34.7602 17.5047C35.0276 17.4699 35.2951 17.4236 35.5625 17.3888C36.1904 17.0874 36.8066 16.786 37.4345 16.4847C37.7369 16.4615 38.0392 16.4383 38.3415 16.4151C38.3415 16.531 38.3182 16.6469 38.3182 16.7628H38.4345C38.388 16.6469 38.3531 16.5426 38.3066 16.4383C38.6903 16.2064 39.074 15.963 39.4577 15.7312L39.4345 15.766C39.3763 16.1485 39.5275 16.334 39.9228 16.4499C40.4344 16.589 40.9112 16.8324 41.5856 17.1106C41.2484 17.4467 41.074 17.7365 40.8182 17.8409C40.1903 18.1075 39.5275 18.3045 38.8764 18.5248C38.4461 18.6639 37.9578 18.7218 37.5741 18.9421C35.5392 20.1128 33.2021 20.5765 31.1208 21.6429L31.051 21.5734L31.1091 21.6777C30.9231 21.7704 30.7371 21.8516 30.3533 22.037C31.0161 22.6398 31.5859 23.115 32.0975 23.6367C33.6091 25.1668 35.0858 26.72 36.609 28.2385C37.0508 28.679 37.5973 29.0152 38.0857 29.3977L38.0159 29.3397L38.0624 29.3977C39.2601 30.7076 40.4461 32.0174 41.6437 33.3157C41.8181 33.5127 42.0623 33.6518 42.2832 33.8141C42.0274 34.2662 42.0972 34.6603 42.4228 35.066C42.7948 35.5181 43.132 36.0049 43.4809 36.4686C43.7716 36.8627 44.1553 37.222 43.9343 37.8016L43.9692 37.8248C43.3646 37.4886 42.76 37.1641 42.167 36.8279C42.0739 36.7352 41.9809 36.6425 41.8879 36.5497C41.4577 35.3674 40.4577 34.6951 39.5042 33.988L39.4345 34.0112H39.5391C39.9112 35.2283 40.9577 35.831 41.8995 36.5265C41.9925 36.6193 42.0856 36.712 42.1786 36.8047C42.167 36.9438 42.1553 37.0713 42.1204 37.4307C41.3414 36.8163 40.6437 36.2831 39.9693 35.7151C39.5973 35.4022 39.3298 34.9964 38.6903 35.2283C38.4694 35.3094 38.0508 34.8689 37.7252 34.6603L37.7485 34.6023C37.6438 34.498 37.5276 34.3821 37.4229 34.2778H37.3764C36.9927 34.0691 36.609 33.8605 36.2253 33.6402C36.0276 33.5243 35.8067 33.2809 35.6439 33.3041C34.6323 33.5011 34.1556 32.794 33.5393 32.2376C31.9579 30.8119 30.365 29.4209 28.7487 28.0415C27.3999 26.8939 27.3999 26.9403 25.8418 27.7285C24.5861 28.3545 23.4 29.0268 22.7838 30.4062C22.5861 30.8351 22.1559 31.148 21.8303 31.5074L21.7838 31.4726C21.5978 31.9826 21.5048 32.5506 21.2141 32.9911C19.749 35.1587 18.5979 37.5466 16.784 39.4824V39.4476C16.4933 39.8417 16.1561 40.2243 15.9119 40.6416C15.5631 41.2675 15.0398 41.3255 14.4236 41.2096L14.3887 41.2443C14.6445 40.7923 14.9003 40.3402 15.1561 39.8997C15.0631 39.8302 14.9701 39.7606 14.8771 39.7026C13.0399 41.3023 11.7725 43.4583 9.81905 45C10.04 44.6291 10.2609 44.2465 10.4818 43.864L10.412 43.7945L10.4935 43.8988C9.86556 44.0031 9.23767 44.0959 8.30746 44.2466C9.66789 42.2296 10.9004 40.4097 12.1446 38.5783C12.0864 38.5203 12.0283 38.4739 11.9818 38.416C11.7841 38.5551 11.5632 38.671 11.4004 38.8333C10.7725 39.4476 10.1679 40.0736 9.53998 40.6995C8.55164 41.6964 7.67958 42.8556 6.09823 42.9947C5.79591 43.0178 5.51685 43.2613 5.22616 43.4004L5.19128 43.4351C5.21453 43.2149 5.22616 42.9947 5.26104 42.786L5.3308 42.8671L5.2843 42.786C5.1564 42.6585 4.93547 42.531 4.93547 42.4035C4.93547 41.9282 4.99361 41.453 5.04012 40.9777C5.17965 40.8966 5.31918 40.8154 5.45871 40.7343C5.45871 40.5256 5.47034 40.317 5.48197 40.1083L5.57499 40.1315L5.50521 40.0852C5.50521 40.3054 5.4936 40.5257 5.48197 40.7575C5.34244 40.8386 5.20291 40.9198 5.06338 41.0125C4.56339 41.1864 4.05177 41.3602 3.40062 41.5921C3.0518 41.0473 2.69135 40.4561 2.31927 39.8649L2.34253 39.9113C2.28439 39.749 2.21462 39.5867 2.15648 39.4244L2.22624 39.3781C2.22624 39.3781 2.17974 39.4592 2.19136 39.4708C2.13323 39.6215 2.07508 39.7722 2.00532 39.9113L2.0402 39.8649C1.93555 39.9692 1.81928 40.0852 1.71463 40.1895C1.40068 40.4097 1.08674 40.6184 0.749538 40.8386C0.784421 40.6763 0.807678 40.5141 0.842561 40.3518C0.958837 40.2011 1.20303 40.0272 1.17977 39.9229C0.842571 38.2305 2.09834 37.2452 2.8425 36.0165V35.9933C2.95878 35.9933 3.07506 35.9933 3.19134 35.9933V36.0165C3.34249 35.6572 3.49365 35.2862 3.65643 34.9269C3.84247 34.9733 4.02852 35.008 4.20293 35.0544C4.00526 35.0196 3.8076 34.9849 3.60993 34.9617C3.81923 34.6487 4.02851 34.3473 4.23781 34.0343V34.0575C4.34246 34.0575 4.45874 34.0575 4.57502 34.0575L4.56338 34.0112C5.1215 33.8952 5.22615 33.4316 5.34243 32.9911H5.36569C5.36569 32.8752 5.36569 32.7593 5.36569 32.6318H5.3308C6.41217 32.1217 6.44705 32.029 5.78428 31.3335H5.7494C6.10985 30.6148 6.48193 29.8729 6.92378 28.9688C6.43542 28.8761 6.06334 28.8065 5.69126 28.737L5.72614 28.7717C5.35406 28.111 4.72617 28.6326 4.14479 28.3892C3.95875 28.1342 3.69132 27.7865 3.42388 27.4387C3.44714 27.3576 3.47039 27.288 3.49365 27.2069C3.48202 27.2996 3.47039 27.3808 3.45876 27.4735C3.08668 27.346 2.70297 27.2185 2.33089 27.0794L2.36577 27.1142C2.41228 26.8244 2.4588 26.5346 2.50531 26.2564C2.57508 26.21 2.65646 26.1636 2.72622 26.1173C2.66808 26.1752 2.59833 26.2332 2.54019 26.2911L2.49367 26.2332ZM19.7722 33.3157C19.9699 33.3041 20.1676 33.2809 20.3653 33.2693C21.028 32.0058 21.6792 30.7307 22.3071 29.5368C20.2374 29.3861 19.3653 30.9046 18.3421 32.284C18.47 32.794 18.6095 33.3272 18.7839 34.0227C19.249 33.3504 19.563 32.6549 20.3653 33.2693C20.1676 33.2925 19.9699 33.3273 19.7839 33.362L19.8304 33.42L19.7722 33.3273V33.3157ZM17.9235 33.7214C17.8421 33.7677 17.7491 33.8257 17.6677 33.8721C17.7142 33.9184 17.7607 33.9532 17.8072 33.9996C17.8304 33.8952 17.8653 33.7909 17.8886 33.6982H17.9235V33.7214ZM14.9701 34.44C14.9701 34.753 14.9933 35.0544 15.005 35.3674C14.4003 35.3442 14.098 35.7267 13.8538 36.1904H13.9468L13.8306 36.1672C14.2259 35.9006 14.6096 35.634 15.005 35.3558C14.9817 35.0544 14.9701 34.753 14.9584 34.4632L15.0398 34.498L14.9817 34.44H14.9701ZM24.3768 8.72986C24.3768 8.72986 24.2837 8.84577 24.2372 8.90373C24.2721 8.83418 24.307 8.77622 24.3303 8.70667V8.68349L24.3768 8.72986ZM6.65635 39.4012C6.65635 39.4012 6.71449 39.4244 6.73775 39.436C6.70287 39.436 6.66797 39.436 6.63309 39.436L6.69123 39.5056L6.65635 39.4129V39.4012ZM27.1674 3.93094L27.2139 3.87298C27.2139 3.87298 27.2139 3.95413 27.2023 3.95413L27.1674 3.93094ZM30.9231 11.0134C30.9231 11.0134 30.9696 11.0482 30.9929 11.0714C30.958 11.0714 30.9347 11.0482 30.8998 11.0366L30.9696 11.0945L30.9231 11.0134ZM11.7725 41.8355C11.7376 42.0326 11.7027 42.2296 11.6562 42.4151L11.5748 42.3803L11.6329 42.4383C11.6678 42.2296 11.7027 42.0094 11.7376 41.8007C11.7957 41.5225 11.8539 41.2559 11.9004 40.9777C12.0399 40.9661 12.1795 40.9545 12.3306 40.9314C12.3306 40.8966 12.319 40.8618 12.3073 40.827C12.1678 40.8734 12.0399 40.9313 11.9004 40.9777C11.8539 41.2675 11.8074 41.5457 11.7725 41.8355ZM23.4233 9.93538C23.4233 9.93538 23.528 9.83107 23.5977 9.74993C23.528 9.84266 23.4931 9.90062 23.4466 9.98176C23.3652 10.1209 23.2954 10.26 23.214 10.3991C23.2722 10.4222 23.3187 10.4338 23.3768 10.457C23.3884 10.2831 23.4117 10.1093 23.4233 9.93538ZM27.8883 10.8395C27.1209 10.7352 27.1325 11.535 26.7255 11.8364C26.7255 11.8364 26.7255 11.8364 26.7372 11.8248C27.1093 11.5003 27.493 11.1641 27.8534 10.8279C27.9115 10.5382 27.9581 10.26 28.0511 9.79629C27.6325 10.2252 27.6441 10.5266 27.8883 10.8395ZM26.0279 6.13334C26.2139 5.79718 26.4 5.47262 26.6325 5.03214C25.5163 5.18283 25.3884 5.33352 25.4465 6.1913L25.4116 6.16811C25.5163 6.16811 25.6093 6.14494 25.7139 6.14494C25.8186 6.14494 25.9232 6.14494 26.0279 6.14494V6.13334ZM27.1558 7.68661C26.8069 8.15027 26.679 8.66031 26.9 9.21671L26.8651 9.18193C27.6209 8.04596 28.3883 6.90998 29.1324 5.76241C29.1906 5.66968 29.1092 5.49579 29.0976 5.36829C28.9929 5.36829 28.8883 5.36829 28.7836 5.36829C27.8418 5.85513 27.493 6.75928 27.1906 7.68661H27.1558ZM15.9119 39.1926C16.1328 39.0419 16.3654 38.9144 16.5514 38.7405C17.656 37.6625 18.0863 36.1904 18.8304 34.8921C18.8304 34.8573 18.8537 34.811 18.8537 34.7762C18.8537 34.753 18.8188 34.7414 18.7955 34.7298C18.8304 34.7878 18.8537 34.8573 18.8886 34.9153C17.8537 34.9501 17.7491 34.9964 17.1793 35.889C17.2607 35.889 17.3537 35.889 17.4351 35.889C17.47 35.889 17.4816 35.8194 17.5049 35.7847L17.47 35.8079C17.3421 36.2136 17.2142 36.6193 17.0863 37.0366H17.063L17.0979 36.9902C16.5165 37.6393 15.784 38.2073 15.9468 39.2274C15.8654 39.3433 15.784 39.4708 15.7142 39.5867C15.7491 39.5983 15.784 39.6099 15.8189 39.6331C15.8538 39.4824 15.877 39.3433 15.9119 39.1926ZM23.2373 25.2479C22.9233 25.4334 22.621 25.7 22.2722 25.7927C21.3071 26.0477 21.1094 26.778 20.9117 27.7401C21.7954 27.4387 22.5396 27.1953 23.2954 26.9403C22.6675 28.3081 20.9583 28.0878 20.0978 29.4209C23.7489 28.3429 24.9698 27.1953 24.8419 24.9233C24.2954 25.0277 23.7838 25.1204 23.2605 25.2131C23.2605 25.2247 23.2489 25.2363 23.2373 25.2595V25.2479ZM25.2605 27.0678C25.3302 27.1605 25.4 27.2417 25.4698 27.3344C25.7953 27.1026 26.1209 26.8707 26.6674 26.4882C25.7023 26.1984 25.4116 26.4998 25.2605 27.0678ZM30.4812 21.0749C30.4464 20.9938 30.3998 20.901 30.365 20.8199C30.0859 20.9358 29.8068 21.0633 29.5278 21.1793C29.5743 21.272 29.6092 21.3647 29.6557 21.4574C29.9347 21.3299 30.2138 21.2024 30.4929 21.0749H30.4812ZM25.4 7.14182C25.307 7.09545 25.214 7.03749 25.1209 6.99112C24.993 7.26932 24.8768 7.54752 24.7488 7.82572C24.8186 7.86049 24.8884 7.89526 24.9582 7.93004C25.1093 7.66343 25.2605 7.40842 25.4116 7.14182H25.4ZM35.2137 14.8386L35.109 14.8734L35.1904 14.9314L35.2137 14.8386ZM28.9348 8.19664L28.9929 8.11551H28.9115L28.9464 8.19664H28.9348ZM34.5393 19.6028L34.4928 19.6607H34.5625L34.5393 19.6028ZM30.6324 19.6028L30.5859 19.6607H30.6557L30.6324 19.6028ZM6.91216 37.535L6.95866 37.4655H6.8889L6.92378 37.535H6.91216ZM7.40051 38.5783L7.47027 38.6246V38.5435L7.40051 38.5783Z"
                        />
                    </svg>
					<span class="text-gradient">influencers</span> and top-tier social media agencies.';

                $find->save();
            }
        }

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
